<?php
require_once 'load_data.php';
$allData = getAllData();
$jsonData = json_encode($allData, JSON_UNESCAPED_UNICODE);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SAE 303 - Mode Artistique</title>
    
    <!-- D3.js -->
    <script src="https://d3js.org/d3.v7.min.js"></script>
    
    <!-- CSS TV Rétro -->
    <link rel="stylesheet" href="tv-retro.css">
    <link rel="stylesheet" href="artistic-mode.css">
    <link rel="stylesheet" href="tv-outro.css">
    
    <!-- Données -->
    <script>
        window.CSV_DATA = <?php echo $jsonData; ?>;
    </script>
    
    <style>
        /* Style spécifique pour la page artistique unique */
        .artistic-header-simple {
            padding: 15px;
            text-align: center;
            background: linear-gradient(135deg, rgba(0, 102, 170, 0.15), rgba(0, 136, 204, 0.1));
            border-bottom: 3px solid var(--tv-accent, #0066aa);
            margin-bottom: 15px;
        }
        
        .artistic-title {
            font-size: 20px;
            font-weight: 700;
            color: var(--tv-text, #1a1a1a);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
        }
        
        .artistic-title svg {
            color: var(--tv-accent, #0066aa);
        }
        
        .artistic-main-area {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 15px;
            padding: 15px;
            height: calc(100vh - 200px);
        }
        
        .artistic-visualization {
            width: 100%;
            flex: 1;
            background: rgba(0, 0, 0, 0.03);
            border-radius: 12px;
            border: 2px solid rgba(0, 102, 170, 0.2);
            overflow: hidden;
            position: relative;
            min-height: 500px;
        }
        
        .artistic-d3-container {
            width: 100%;
            height: 100%;
            position: relative;
        }
        
        /* Style pour l'image SVG de fond - GRAND ÉCRAN */
        .svg-background {
            width: 100%;
            height: 100%;
            background-image: url('images/Dataviz_V1.svg');
            background-size: contain;
            background-position: center;
            background-repeat: no-repeat;
            opacity: 1;
            /* Retrait des filtres pour garder les couleurs originales */
            filter: none;
        }
        
        .artistic-stats-row {
            display: flex;
            justify-content: center;
            gap: 30px;
            flex-wrap: wrap;
            padding: 12px;
            background: rgba(0, 0, 0, 0.03);
            border-radius: 8px;
        }
        
        .artistic-stat {
            text-align: center;
        }
        
        .artistic-stat-value {
            font-size: 24px;
            font-weight: 700;
            color: var(--tv-accent, #0066aa);
        }
        
        .artistic-stat-label {
            font-size: 11px;
            color: var(--tv-text-dim, #505050);
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .artistic-description {
            max-width: 600px;
            text-align: center;
            padding: 15px;
            background: rgba(255, 255, 255, 0.5);
            border-radius: 8px;
            border-left: 4px solid var(--tv-accent, #0066aa);
            margin-top: 10px;
        }
        
        .artistic-description p {
            color: var(--tv-text, #1a1a1a);
            line-height: 1.6;
            font-size: 13px;
            margin: 0;
        }
        
        /* Mode toggle pour retourner */
        .back-btn-container {
            position: fixed;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            z-index: 100;
        }
        
        .back-btn {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 12px 25px;
            background: var(--tv-accent, #0066aa);
            color: white;
            border: none;
            border-radius: 25px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            box-shadow: 0 4px 15px rgba(0, 102, 170, 0.3);
            transition: all 0.3s ease;
            text-decoration: none;
        }
        
        .back-btn:hover {
            background: var(--tv-accent-glow, #0088cc);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0, 102, 170, 0.4);
        }
        
        /* Ajustement du conteneur TV pour plus d'espace */
        .tv-screen {
            padding: 10px;
        }
        
        /* Top status bar compacte */
        .tv-top-status {
            height: 40px;
            padding: 5px 10px;
        }
    </style>
</head>
<body>
    <!-- Barre de progression de défilement -->
    <div class="tv-progress-bar" id="tvProgressBar"></div>

    <!-- Container Principal TV Rétro -->
    <div class="tv-retro-container" id="tvRetroContainer">
        
        <!-- Cadre TV -->
        <div class="tv-frame">
            <div class="tv-screen">
                
                <!-- Effets CRT -->
                <div class="tv-scanlines"></div>
                <div class="tv-vignette"></div>
                <div class="tv-flicker"></div>
                <div class="tv-glow"></div>
                <div class="tv-curvature"></div>
                <div class="tv-scanline-bar"></div>
                
                <!-- En-tête TV & Horloge & CRT-->
                <div class="tv-top-status">
                    <div class="crt-status">
                        <span class="led"></span>
                        CRT: ON
                    </div>
                    <div class="marquee-container">
                        <div class="tv-clock-marquee" id="tvClock">00:00:00</div>
                    </div>
                    
                 <!-- Indicateur de Mode -->
                <div class="tv-mode-indicator">
                    <button class="tv-mode-btn active" id="modeScientific">
                        <svg viewBox="0 0 24 24" width="16" height="16" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M12 2v20M2 12h20"></path>
                            <circle cx="12" cy="12" r="9"></circle>
                        </svg>
                        Scientifique
                    </button>
                    <a href="artistic.php" class="tv-mode-btn" id="modeArtisticLink">
                        <svg viewBox="0 0 24 24" width="16" height="16" fill="none" stroke="currentColor" stroke-width="2">
                            <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                        </svg>
                        Artistique
                    </a>
                </div>
                
            </div>
                
                <!-- Signal -->
                <div class="tv-signal">
                    <div class="tv-signal-bars">
                        <div class="signal-bar"></div>
                        <div class="signal-bar"></div>
                        <div class="signal-bar"></div>
                        <div class="signal-bar"></div>
                    </div>
                    <span>SIGNAL</span>
                </div>
                
                <!-- Zone principale artistique -->
                <div class="artistic-main-area">
                    
                    <!-- Visualisation avec SVG de fond -->
                    <div class="artistic-visualization">
                        <div class="artistic-d3-container" id="artistic-d3-container">
                            <!-- Image SVG de fond -->
                            <div class="svg-background"></div>
                        </div>
                    </div>
                    
                    <!-- Description -->
                    <div class="artistic-description">
                        <p>
                            Cette visualisation artistique représente le temps de parole des femmes dans les médias français.
                            Le design circulaire avec ses échelles concentriques symbolise la mesure et l'équilibre dans la représentation médiatique.
                            Une exploration poétique des données de parité dans les médias.
                        </p>
                    </div>
                    
                </div>
                
            </div>
        </div>
        
        <!-- Compteur de Données -->
        <div class="tv-data-counter" id="tvDataCounter">
            DONNÉES <span>000</span>
        </div>
        
        <!-- Graphisme de défilement TV -->
        <div class="tv-scroll-graphic">
            <svg class="tv-scroll-icon up" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <polyline points="18 15 12 9 6 15"></polyline>
            </svg>
            <div class="tv-scroll-track">
                <div class="tv-scroll-position"></div>
            </div>
            <svg class="tv-scroll-icon down" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <polyline points="6 9 12 15 18 9"></polyline>
            </svg>
            <div class="tv-scroll-counter">SCROLL</div>
        </div>
        
        <!-- Bouton retour -->
        <div class="back-btn-container">
            <a href="index.php" class="back-btn">
                <svg viewBox="0 0 24 24" width="16" height="16" fill="none" stroke="currentColor" stroke-width="2">
                    <polyline points="15 18 9 12 15 6"></polyline>
                </svg>
                Retour au mode scientifique
            </a>
        </div>
        
    </div>

    <!-- Sélecteur d'année (caché) -->
    <select id="yearFilter" style="display:none;">
        <?php
        $yearsData = getYearsData();
        foreach ($yearsData['years'] as $year) {
            $selected = ($year == '2019') ? 'selected' : '';
            echo "<option value='$year' $selected>$year</option>";
        }
        ?>
    </select>

    <!-- Scripts -->
    <script src="tv-graphics.js"></script>
    <script src="tv-outro.js"></script>
    
    <script>
        // Fonction pour mettre à jour les stats artistiques
        function updateArtisticStats() {
            const year = document.getElementById('yearFilter')?.value || '2019';
            document.getElementById('yearDisplayArt').textContent = year;
            
            // Calculer la moyenne à partir des données
            if (window.CSV_DATA && window.CSV_DATA.length > 0) {
                try {
                    const currentYearData = window.CSV_DATA.filter(d => d.Year === year);
                    if (currentYearData.length > 0) {
                        const totalWomen = currentYearData.reduce((sum, d) => {
                            const womenValue = parseFloat(d.Women) || 0;
                            return sum + womenValue;
                        }, 0);
                        
                        const avgWomen = totalWomen / currentYearData.length;
                        document.getElementById('avgWomen').textContent = avgWomen.toFixed(1) + '%';
                        document.getElementById('totalChannels').textContent = currentYearData.length;
                    }
                } catch (e) {
                    console.log('Erreur dans le calcul des stats:', e);
                }
            }
        }
        
        // Fonction d'initialisation principale
        function initializeArtisticPage() {
            console.log('Initializing artistic page avec SVG de fond...');
            
            // Pas besoin d'initialiser D3, on utilise juste l'image de fond
            updateArtisticStats();
            
            // Animation subtile au chargement - seulement opacité
            const svgBackground = document.querySelector('.svg-background');
            if (svgBackground) {
                svgBackground.style.transition = 'opacity 1s ease';
                svgBackground.style.opacity = '0.9';
            }
        }
        
        // Initialiser au chargement du DOM
        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', function() {
                setTimeout(initializeArtisticPage, 300);
            });
        } else {
            setTimeout(initializeArtisticPage, 300);
        }
        
        // Gérer les changements d'année
        document.getElementById('yearFilter')?.addEventListener('change', function() {
            updateArtisticStats();
        });
    </script>
</body>
</html>